/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.rjmx.services.flr.IConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.IOptionConstraint;
import com.jrockit.mc.rjmx.services.flr.OpenTypeConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.OptionHelper;

public class StringConvertibleValue<T extends Comparable<T>>
implements IConvertibleValue<T> {
    private final IOptionConstraint<T> constraint;
    private final String stringValue;
    private final T openTypeValue;

    public static <T extends Comparable<T>> IConvertibleValue<T> create(IOptionConstraint<T> constraint, String value) throws QuantityConversionException {
        return new StringConvertibleValue<T>(constraint, value);
    }

    public StringConvertibleValue(IOptionConstraint<T> constraint, String stringValue) throws QuantityConversionException {
        this.constraint = constraint;
        this.stringValue = stringValue;
        this.openTypeValue = OptionHelper.toServerValue(constraint, stringValue);
    }

    @Override
    public IOptionConstraint<T> getConstraint() {
        return this.constraint;
    }

    @Override
    public T toServerOpenType() {
        return this.openTypeValue;
    }

    @Override
    public String toConfigString() {
        return this.stringValue;
    }

    @Override
    public IConvertibleValue<T> toCanonical() {
        return new OpenTypeConvertibleValue<Object>(this.constraint, this.toServerOpenType());
    }

    public boolean equals(Object other) {
        return other instanceof IConvertibleValue && this.openTypeValue.equals(((IConvertibleValue)other).toServerOpenType());
    }

    public int hashCode() {
        return this.openTypeValue.hashCode();
    }
}

