/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.multichart;

import com.jrockit.mc.flightrecorder.ui.components.multichart.IChartLabelProvider;
import com.jrockit.mc.flightrecorder.ui.components.multichart.ImageRepository;
import com.jrockit.mc.ui.model.fields.Field;
import java.awt.Image;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class FieldChartLabelProvider
extends BaseLabelProvider
implements IChartLabelProvider {
    private final ImageRepository m_imageRepository;
    private Field m_field;
    private final int m_width;
    private final int m_height;

    FieldChartLabelProvider(int width, int height, int maxCount, Field field) {
        this.m_field = field;
        this.m_width = width;
        this.m_height = height;
        this.m_imageRepository = new ImageRepository(width, height, maxCount);
    }

    @Override
    public Image getImage(Object element) {
        Image image = this.m_imageRepository.getImage(element);
        if (image == null) {
            if (element != null) {
                this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, element));
            }
            return this.m_imageRepository.getProgressImage();
        }
        return image;
    }

    @Override
    public String getText(Object element) {
        return this.m_field.formatObject(element);
    }

    public void setField(Field field) {
        this.m_field = field;
    }

    public void addImage(Object element, Image image) {
        this.m_imageRepository.addImage(element, image);
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }
}

