/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.ui.model.fields.Field;

public abstract class DecoratorField
extends Field {
    public final Field m_decoree;

    public DecoratorField(Field field) {
        super(field.INDEX);
        if (field instanceof DecoratorField) {
            throw new IllegalArgumentException("Can't decorate a decorated field");
        }
        this.m_decoree = field;
        this.setModifiable(field.isModifiable());
        this.setProperties(field.getProperties());
    }

    public Object removeDecorationData(Object object) {
        if (object instanceof DecoratorData) {
            return ((DecoratorData)object).getMainData();
        }
        return object;
    }

    @Override
    public String formatObject(Object object) {
        return this.m_decoree.formatObject(this.removeDecorationData(object));
    }

    @Override
    public String getUnit() {
        return this.m_decoree.getUnit();
    }

    @Override
    public String getTooltip(Object object) {
        return this.m_decoree.getTooltip(this.removeDecorationData(object));
    }

    @Override
    public int compare(Object a, Object b, boolean order) {
        return this.m_decoree.compare(this.removeDecorationData(a), this.removeDecorationData(b), order);
    }

    @Override
    public void setInput(Object input) {
        this.m_decoree.setInput(input);
    }

    @Override
    public String formatForClipboard(Object object) {
        return this.m_decoree.formatForClipboard(this.removeDecorationData(object));
    }

    public Field getMainField() {
        return this.m_decoree;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_decoree.dispose();
    }

    public static class DecoratorData {
        private final Object m_decoratedData;
        private final Object m_mainData;

        public DecoratorData(Object mainData, Object decoratedData) {
            this.m_mainData = mainData;
            this.m_decoratedData = decoratedData;
        }

        public Object getMainData() {
            return this.m_mainData;
        }

        public Object getDecoratedData() {
            return this.m_decoratedData;
        }
    }
}

