/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.threads;

import com.jrockit.mc.console.ui.actions.ResetToDefaultsAction;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.console.ui.tabs.threads.DummyThreadsModel;
import com.jrockit.mc.console.ui.tabs.threads.IThreadsModel;
import com.jrockit.mc.console.ui.tabs.threads.ThreadMasterDetailBlock;
import com.jrockit.mc.console.ui.tabs.threads.ThreadsModel;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import com.jrockit.mc.ui.misc.MCActionContributionItem;
import com.jrockit.mc.ui.misc.VerticalSectionLayout;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ThreadTab
extends ConsoleTab {
    private static final String HELP_THREAD_TAB_THREAD_GRAPH_SECTION_CONTEXT = "com.jrockit.mc.console.ui.help_ThreadGraphSection";
    private static final String CHART_ID = "threadsChart";
    private boolean m_platformThreadingMBeanPresent = true;
    private IThreadsModel m_model;
    private CombinedChartSectionPart m_graphSectionPart;

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.m_model = this.m_platformThreadingMBeanPresent ? new ThreadsModel(this.getConnectionHandle()) : new DummyThreadsModel();
        ScrolledForm form = managedForm.getForm();
        Composite container = managedForm.getForm().getBody();
        IToolBarManager toolbarManager = form.getToolBarManager();
        toolbarManager.prependToGroup("MC_TB_GROUP", (IContributionItem)new MCActionContributionItem((IAction)new ResetToDefaultsAction(){

            @Override
            protected void reset() {
                ThreadTab.this.m_graphSectionPart.restoreState(ThreadTab.this.getDefaultConfig().getChild(ThreadTab.CHART_ID));
            }
        }));
        toolbarManager.update(true);
        this.createThreadUsageGraph(managedForm, container, this.loadState());
        this.createMasterDetailBlock(managedForm, container, this.m_model);
        container.setLayout((Layout)new VerticalSectionLayout());
    }

    @Override
    protected void validateDependencies() {
        MBeanServerConnection connection = (MBeanServerConnection)this.getConnectionHandle().getServiceOrNull(MBeanServerConnection.class);
        try {
            if (connection.queryNames(new ObjectName("java.lang:type=Threading"), null).isEmpty()) {
                this.showMessage(Messages.ConsoleEditor_PLATFORM_MBEANS_UNAVAILABLE);
                this.m_platformThreadingMBeanPresent = false;
            }
        }
        catch (Exception e) {
            this.showMessage(Messages.ConsoleEditor_CONNECTION_LOST);
            this.m_platformThreadingMBeanPresent = false;
        }
    }

    public void createMasterDetailBlock(IManagedForm managedForm, Composite parent, IThreadsModel model) {
        ThreadMasterDetailBlock masterDetailBlock = new ThreadMasterDetailBlock((IFormPage)this, model);
        masterDetailBlock.createContent(managedForm, parent);
        masterDetailBlock.getSashForm().setWeights(new int[]{2, 1});
    }

    private void createThreadUsageGraph(IManagedForm managedForm, Composite parent, IMemento state) {
        int style = 258;
        this.m_graphSectionPart = new CombinedChartSectionPart(parent, this.getToolkit(), style, HELP_THREAD_TAB_THREAD_GRAPH_SECTION_CONTEXT, this.getConnectionHandle());
        managedForm.addPart((IFormPart)this.m_graphSectionPart);
        this.m_graphSectionPart.restoreState(state.getChild(CHART_ID));
        this.m_graphSectionPart.getSection().setExpanded(false);
    }

    @Override
    public void dispose() {
        if (this.m_model != null) {
            this.m_model.dispose();
            this.m_model = null;
        }
        super.dispose();
    }

    @Override
    public boolean saveState(IMemento state) {
        this.m_graphSectionPart.saveState(state.createChild(CHART_ID));
        return true;
    }

    protected String getHelpContextID() {
        return "com.jrockit.mc.console.ui.ThreadTab";
    }
}

