/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.provider;

import com.jrockit.mc.flightrecorder.provider.EventType;
import com.jrockit.mc.flightrecorder.provider.Field;
import com.jrockit.mc.flightrecorder.provider.bcel.Arguments;
import com.jrockit.mc.flightrecorder.provider.bcel.BCELUtilities;
import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFactory;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IFieldFactory;
import java.lang.reflect.Constructor;

public class DefaultFactories {
    private DefaultFactories() {
    }

    public static IEventFactory createEventFactory(int fieldCount) {
        return new BCELEventFactory(fieldCount);
    }

    public static IFieldFactory createFieldFactory(EventType eventType, int fieldCount) {
        return new BCELFieldFactory(eventType, fieldCount);
    }

    private static class BCELEventFactory
    implements IEventFactory {
        private final Constructor<?> constructor;
        private final Arguments arguments = new Arguments();
        private final Object[] reflectionArgument = new Object[]{this.arguments};

        private BCELEventFactory(int fieldCount) {
            this.constructor = BCELUtilities.getEventConstructor(fieldCount);
        }

        @Override
        public IEvent createEvent(long startTime, long endTime, IEventType eventType, Object ... values) {
            try {
                this.arguments.startTime = startTime;
                this.arguments.endTime = endTime;
                this.arguments.type = eventType;
                this.arguments.values = values;
                return (IEvent)this.constructor.newInstance(this.reflectionArgument);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private static class BCELFieldFactory
    implements IFieldFactory {
        private final EventType eventType;
        private final int fieldCount;
        private int fieldIndex;

        private BCELFieldFactory(EventType eventType, int fieldCount) {
            this.fieldCount = fieldCount;
            this.eventType = eventType;
        }

        @Override
        public Field createValueField(String identifier, String path, String contentType, String name, String desc, String relationalKey, FieldType fieldType, String ... additionalProperties) {
            Field f = BCELUtilities.createField(this.eventType, this.fieldIndex++, this.fieldCount, identifier);
            f.setFieldType(fieldType);
            f.setPath(path);
            f.setContentType(contentType);
            f.setName(name);
            f.setDescription(desc);
            f.setRelationalKey(relationalKey);
            if (additionalProperties != null) {
                String[] stringArray = additionalProperties;
                int n = additionalProperties.length;
                int n2 = 0;
                while (n2 < n) {
                    String prop = stringArray[n2];
                    f.addProperty(prop);
                    ++n2;
                }
            }
            this.eventType.addField(f);
            return f;
        }
    }
}

