/*
 * Decompiled with CFR 0.152.
 */
package com.javafx.tools.doclets.formats.html;

import com.javafx.tools.doclets.formats.html.ConfigurationImpl;
import com.javafx.tools.doclets.formats.html.HtmlDocletWriter;
import com.javafx.tools.doclets.formats.html.markup.HtmlConstants;
import com.javafx.tools.doclets.formats.html.markup.HtmlStyle;
import com.javafx.tools.doclets.formats.html.markup.HtmlTag;
import com.javafx.tools.doclets.formats.html.markup.HtmlTree;
import com.javafx.tools.doclets.internal.toolkit.Content;
import com.javafx.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.IOException;

public class HelpWriter
extends HtmlDocletWriter {
    public HelpWriter(ConfigurationImpl configuration, String filename) throws IOException {
        super(configuration, filename);
    }

    public static void generate(ConfigurationImpl configuration) {
        String filename = "";
        try {
            filename = "help-doc.html";
            HelpWriter helpgen = new HelpWriter(configuration, filename);
            helpgen.generateHelpFile();
            helpgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateHelpFile() {
        String title = this.configuration.getText("doclet.Window_Help_title");
        HtmlTree body = this.getBody(true, this.getWindowTitle(title));
        this.addTop(body);
        this.addNavLinks(true, body);
        this.addHelpFileContents(body);
        this.addNavLinks(false, body);
        this.addBottom(body);
        this.printHtmlDocument(null, true, body);
    }

    protected void addHelpFileContents(Content contentTree) {
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, false, HtmlStyle.title, this.getResource("doclet.Help_line_1"));
        HtmlTree div = HtmlTree.DIV(HtmlStyle.header, heading);
        HtmlTree line2 = HtmlTree.DIV(HtmlStyle.subTitle, this.getResource("doclet.Help_line_2"));
        ((Content)div).addContent(line2);
        contentTree.addContent(div);
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        ul.addStyle(HtmlStyle.blockList);
        if (this.configuration.createoverview) {
            HtmlTree overviewHeading = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Overview"));
            HtmlTree liOverview = HtmlTree.LI(HtmlStyle.blockList, overviewHeading);
            Content line3 = this.getResource("doclet.Help_line_3", this.getHyperLinkString("overview-summary.html", this.configuration.getText("doclet.Overview")));
            HtmlTree overviewPara = HtmlTree.P(line3);
            ((Content)liOverview).addContent(overviewPara);
            ul.addContent(liOverview);
        }
        HtmlTree packageHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Package"));
        HtmlTree liPackage = HtmlTree.LI(HtmlStyle.blockList, packageHead);
        Content line4 = this.getResource("doclet.Help_line_4");
        HtmlTree packagePara = HtmlTree.P(line4);
        ((Content)liPackage).addContent(packagePara);
        HtmlTree ulPackage = new HtmlTree(HtmlTag.UL);
        ulPackage.addContent(HtmlTree.LI(this.getResource("doclet.Interfaces_Italic")));
        ulPackage.addContent(HtmlTree.LI(this.getResource("doclet.Classes")));
        ulPackage.addContent(HtmlTree.LI(this.getResource("doclet.Enums")));
        ulPackage.addContent(HtmlTree.LI(this.getResource("doclet.Exceptions")));
        ulPackage.addContent(HtmlTree.LI(this.getResource("doclet.Errors")));
        ulPackage.addContent(HtmlTree.LI(this.getResource("doclet.AnnotationTypes")));
        ((Content)liPackage).addContent(ulPackage);
        ul.addContent(liPackage);
        HtmlTree classHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Help_line_5"));
        HtmlTree liClass = HtmlTree.LI(HtmlStyle.blockList, classHead);
        Content line6 = this.getResource("doclet.Help_line_6");
        HtmlTree classPara = HtmlTree.P(line6);
        ((Content)liClass).addContent(classPara);
        HtmlTree ul1 = new HtmlTree(HtmlTag.UL);
        ul1.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_7")));
        ul1.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_8")));
        ul1.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_9")));
        ul1.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_10")));
        ul1.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_11")));
        ul1.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_12")));
        ((Content)liClass).addContent(ul1);
        HtmlTree ul2 = new HtmlTree(HtmlTag.UL);
        ul2.addContent(HtmlTree.LI(this.getResource("doclet.Nested_Class_Summary")));
        ul2.addContent(HtmlTree.LI(this.getResource("doclet.Field_Summary")));
        ul2.addContent(HtmlTree.LI(this.getResource("doclet.Constructor_Summary")));
        ul2.addContent(HtmlTree.LI(this.getResource("doclet.Method_Summary")));
        ((Content)liClass).addContent(ul2);
        HtmlTree ul3 = new HtmlTree(HtmlTag.UL);
        ul3.addContent(HtmlTree.LI(this.getResource("doclet.Field_Detail")));
        ul3.addContent(HtmlTree.LI(this.getResource("doclet.Constructor_Detail")));
        ul3.addContent(HtmlTree.LI(this.getResource("doclet.Method_Detail")));
        ((Content)liClass).addContent(ul3);
        Content line13 = this.getResource("doclet.Help_line_13");
        HtmlTree para = HtmlTree.P(line13);
        ((Content)liClass).addContent(para);
        ul.addContent(liClass);
        HtmlTree aHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.AnnotationType"));
        HtmlTree liAnnotation = HtmlTree.LI(HtmlStyle.blockList, aHead);
        Content aline1 = this.getResource("doclet.Help_annotation_type_line_1");
        HtmlTree aPara = HtmlTree.P(aline1);
        ((Content)liAnnotation).addContent(aPara);
        HtmlTree aul = new HtmlTree(HtmlTag.UL);
        aul.addContent(HtmlTree.LI(this.getResource("doclet.Help_annotation_type_line_2")));
        aul.addContent(HtmlTree.LI(this.getResource("doclet.Help_annotation_type_line_3")));
        aul.addContent(HtmlTree.LI(this.getResource("doclet.Annotation_Type_Required_Member_Summary")));
        aul.addContent(HtmlTree.LI(this.getResource("doclet.Annotation_Type_Optional_Member_Summary")));
        aul.addContent(HtmlTree.LI(this.getResource("doclet.Annotation_Type_Member_Detail")));
        ((Content)liAnnotation).addContent(aul);
        ul.addContent(liAnnotation);
        HtmlTree enumHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Enum"));
        HtmlTree liEnum = HtmlTree.LI(HtmlStyle.blockList, enumHead);
        Content eline1 = this.getResource("doclet.Help_enum_line_1");
        HtmlTree enumPara = HtmlTree.P(eline1);
        ((Content)liEnum).addContent(enumPara);
        HtmlTree eul = new HtmlTree(HtmlTag.UL);
        eul.addContent(HtmlTree.LI(this.getResource("doclet.Help_enum_line_2")));
        eul.addContent(HtmlTree.LI(this.getResource("doclet.Help_enum_line_3")));
        eul.addContent(HtmlTree.LI(this.getResource("doclet.Enum_Constant_Summary")));
        eul.addContent(HtmlTree.LI(this.getResource("doclet.Enum_Constant_Detail")));
        ((Content)liEnum).addContent(eul);
        ul.addContent(liEnum);
        if (this.configuration.classuse) {
            HtmlTree useHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Help_line_14"));
            HtmlTree liUse = HtmlTree.LI(HtmlStyle.blockList, useHead);
            Content line15 = this.getResource("doclet.Help_line_15");
            HtmlTree usePara = HtmlTree.P(line15);
            ((Content)liUse).addContent(usePara);
            ul.addContent(liUse);
        }
        if (this.configuration.createtree) {
            HtmlTree treeHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Help_line_16"));
            HtmlTree liTree = HtmlTree.LI(HtmlStyle.blockList, treeHead);
            Content line17 = this.getResource("doclet.Help_line_17_with_tree_link", this.getHyperLinkString("overview-tree.html", this.configuration.getText("doclet.Class_Hierarchy")));
            HtmlTree treePara = HtmlTree.P(line17);
            ((Content)liTree).addContent(treePara);
            HtmlTree tul = new HtmlTree(HtmlTag.UL);
            tul.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_18")));
            tul.addContent(HtmlTree.LI(this.getResource("doclet.Help_line_19")));
            ((Content)liTree).addContent(tul);
            ul.addContent(liTree);
        }
        if (!this.configuration.nodeprecatedlist && !this.configuration.nodeprecated) {
            HtmlTree dHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Deprecated_API"));
            HtmlTree liDeprecated = HtmlTree.LI(HtmlStyle.blockList, dHead);
            Content line20 = this.getResource("doclet.Help_line_20_with_deprecated_api_link", this.getHyperLinkString("deprecated-list.html", this.configuration.getText("doclet.Deprecated_API")));
            HtmlTree dPara = HtmlTree.P(line20);
            ((Content)liDeprecated).addContent(dPara);
            ul.addContent(liDeprecated);
        }
        if (this.configuration.createindex) {
            String indexlink = this.configuration.splitindex ? this.getHyperLinkString("index-files/index-1.html", this.configuration.getText("doclet.Index")) : this.getHyperLinkString("index-all.html", this.configuration.getText("doclet.Index"));
            HtmlTree indexHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Help_line_21"));
            HtmlTree liIndex = HtmlTree.LI(HtmlStyle.blockList, indexHead);
            Content line22 = this.getResource("doclet.Help_line_22", indexlink);
            HtmlTree indexPara = HtmlTree.P(line22);
            ((Content)liIndex).addContent(indexPara);
            ul.addContent(liIndex);
        }
        HtmlTree prevHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Help_line_23"));
        HtmlTree liPrev = HtmlTree.LI(HtmlStyle.blockList, prevHead);
        Content line24 = this.getResource("doclet.Help_line_24");
        HtmlTree prevPara = HtmlTree.P(line24);
        ((Content)liPrev).addContent(prevPara);
        ul.addContent(liPrev);
        HtmlTree frameHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Help_line_25"));
        HtmlTree liFrame = HtmlTree.LI(HtmlStyle.blockList, frameHead);
        Content line26 = this.getResource("doclet.Help_line_26");
        HtmlTree framePara = HtmlTree.P(line26);
        ((Content)liFrame).addContent(framePara);
        ul.addContent(liFrame);
        HtmlTree allclassesHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.All_Classes"));
        HtmlTree liAllClasses = HtmlTree.LI(HtmlStyle.blockList, allclassesHead);
        Content line27 = this.getResource("doclet.Help_line_27", this.getHyperLinkString("allclasses-noframe.html", this.configuration.getText("doclet.All_Classes")));
        HtmlTree allclassesPara = HtmlTree.P(line27);
        ((Content)liAllClasses).addContent(allclassesPara);
        ul.addContent(liAllClasses);
        HtmlTree sHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Serialized_Form"));
        HtmlTree liSerial = HtmlTree.LI(HtmlStyle.blockList, sHead);
        Content line28 = this.getResource("doclet.Help_line_28");
        HtmlTree serialPara = HtmlTree.P(line28);
        ((Content)liSerial).addContent(serialPara);
        ul.addContent(liSerial);
        HtmlTree constHead = HtmlTree.HEADING(HtmlConstants.CONTENT_HEADING, this.getResource("doclet.Constants_Summary"));
        HtmlTree liConst = HtmlTree.LI(HtmlStyle.blockList, constHead);
        Content line29 = this.getResource("doclet.Help_line_29");
        HtmlTree constPara = HtmlTree.P(line29);
        ((Content)liConst).addContent(constPara);
        ul.addContent(liConst);
        HtmlTree divContent = HtmlTree.DIV(HtmlStyle.contentContainer, ul);
        HtmlTree line30 = HtmlTree.EM(this.getResource("doclet.Help_line_30"));
        ((Content)divContent).addContent(line30);
        contentTree.addContent(divContent);
    }

    protected Content getNavLinkHelp() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.helpLabel);
        return li;
    }
}

