/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.arm;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.Debugger;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.cdbg.CFrame;

public abstract class ARMThreadContext
implements ThreadContext {
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.debugger.DEBUG") != null;
    public static final int R_00 = 0;
    public static final int R_01 = 1;
    public static final int R_02 = 2;
    public static final int R_03 = 3;
    public static final int R_04 = 4;
    public static final int R_05 = 5;
    public static final int R_06 = 6;
    public static final int R_07 = 7;
    public static final int R_08 = 8;
    public static final int R_09 = 9;
    public static final int R_10 = 10;
    public static final int R_11 = 11;
    public static final int R_FP = 11;
    public static final int R_12 = 12;
    public static final int R_13 = 13;
    public static final int R_SP = 13;
    public static final int R_14 = 14;
    public static final int R_LR = 14;
    public static final int R_15 = 15;
    public static final int R_PC = 15;
    public static final int NPRGREG = 16;
    private static final String[] regNames = new String[]{"R0", "R1", "R2", "R3", "R4", "R5", "R6", "R7", "R8", "R9", "R10", "FP", "R12", "SP", "LR", "PC"};
    private long[] data = new long[16];

    @Override
    public int getNumRegisters() {
        return 16;
    }

    @Override
    public String getRegisterName(int index) {
        return regNames[index];
    }

    @Override
    public void setRegister(int index, long value) {
        this.data[index] = value;
        if (DEBUG) {
            System.out.println(this.getRegisterName(index) + ": 0x" + Long.toHexString(value));
        }
    }

    @Override
    public long getRegister(int index) {
        return this.data[index];
    }

    @Override
    public abstract void setRegisterAsAddress(int var1, Address var2);

    @Override
    public abstract Address getRegisterAsAddress(int var1);

    @Override
    public abstract CFrame getTopFrame(Debugger var1);
}

