/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view;

import com.jrockit.mc.ui.misc.IInputChangedListener;
import com.jrockit.mc.ui.misc.IMCInputProvider;
import java.util.Observable;
import org.eclipse.jface.viewers.IInputProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ViewPart;

public final class PartHooker
extends Observable
implements IInputChangedListener {
    private final IWorkbenchPart m_part;
    private IMCInputProvider m_lastProvider;
    private Object m_input;
    private final PartListener m_partListener;

    public PartHooker(IWorkbenchPart part) {
        this.m_part = part;
        this.m_partListener = new PartListener(this);
        part.getSite().getPage().addPartListener((IPartListener)this.m_partListener);
    }

    public IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            return page.getActivePart();
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        this.hookPart(part);
    }

    public void hookPart(IWorkbenchPart part) {
        if (part == this.m_part) {
            this.hookBootStrap();
        } else if (!(part instanceof ViewPart) && (IWorkbenchPart)this.m_lastProvider != part) {
            this.cleanUpLastProvider();
            if (part instanceof IMCInputProvider) {
                this.m_lastProvider = (IMCInputProvider)part;
                this.m_lastProvider.addInputChangedListener((IInputChangedListener)this);
                this.setInput(this.getInput(part));
                return;
            }
        }
    }

    private void hookBootStrap() {
        IWorkbenchPart bootStrapPrt = this.getBootstrapPart();
        if (bootStrapPrt != this.m_part) {
            this.hookPart(bootStrapPrt);
        }
    }

    public void inputChanged(Object input) {
        this.setInput(input);
    }

    private void setInput(Object input) {
        this.m_input = input;
        this.setChanged();
        this.notifyObservers(input);
    }

    public Object getInput() {
        IWorkbenchPart wp;
        if (this.m_input == null && (wp = this.getBootstrapPart()) != null) {
            this.m_input = this.getInput(wp);
        }
        return this.m_input;
    }

    public Object getInput(IWorkbenchPart part) {
        if (part instanceof IInputProvider) {
            return ((IInputProvider)part).getInput();
        }
        return null;
    }

    void cleanUpLastProvider() {
        if (this.m_lastProvider != null) {
            this.m_lastProvider.removeInputChangedListener((IInputChangedListener)this);
        }
        this.m_lastProvider = null;
        this.m_input = null;
    }

    private IWorkbenchSite getSite() {
        return this.m_part.getSite();
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener)this.m_partListener);
    }

    static class PartListener
    implements IPartListener {
        PartHooker m_hooker;

        PartListener(PartHooker hooker) {
            this.m_hooker = hooker;
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            this.m_hooker.cleanUpLastProvider();
            this.m_hooker.hookPart(this.m_hooker.getBootstrapPart());
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            this.m_hooker.hookPart(part);
        }
    }
}

