/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.BorderBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.ButtonBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.DataViewBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.JComponentBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.PaneBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.TextComponentBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Utils;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.WindowBuilders;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

final class ComponentBuilders {
    ComponentBuilders() {
    }

    static ComponentBuilder getBuilder(Instance instance, Heap heap) {
        if (Thread.interrupted()) {
            return null;
        }
        ComponentBuilder componentBuilder = JComponentBuilders.getBuilder(instance, heap);
        if (componentBuilder != null) {
            return componentBuilder;
        }
        ComponentBuilder componentBuilder2 = ButtonBuilders.getBuilder(instance, heap);
        if (componentBuilder2 != null) {
            return componentBuilder2;
        }
        ComponentBuilder componentBuilder3 = TextComponentBuilders.getBuilder(instance, heap);
        if (componentBuilder3 != null) {
            return componentBuilder3;
        }
        ComponentBuilder componentBuilder4 = PaneBuilders.getBuilder(instance, heap);
        if (componentBuilder4 != null) {
            return componentBuilder4;
        }
        ComponentBuilder componentBuilder5 = DataViewBuilders.getBuilder(instance, heap);
        if (componentBuilder5 != null) {
            return componentBuilder5;
        }
        ComponentBuilder componentBuilder6 = WindowBuilders.getBuilder(instance, heap);
        if (componentBuilder6 != null) {
            return componentBuilder6;
        }
        if (DetailsUtils.isSubclassOf(instance, JComponent.class.getName())) {
            return new JComponentBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, Container.class.getName())) {
            return new ContainerBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, Component.class.getName())) {
            return new ComponentBuilder(instance, heap);
        }
        return null;
    }

    static class JComponentBuilder<T extends JComponent>
    extends ContainerBuilder<T> {
        private final boolean isAlignmentXSet;
        private final float alignmentX;
        private final boolean isAlignmentYSet;
        private final float alignmentY;
        private final BorderBuilders.BorderBuilder border;
        private final int flags;

        JComponentBuilder(Instance instance, Heap heap) {
            this(instance, heap, true);
        }

        protected JComponentBuilder(Instance instance, Heap heap, boolean bl) {
            super(instance, heap, bl);
            this.isAlignmentXSet = DetailsUtils.getBooleanFieldValue(instance, "isAlignmentXSet", false);
            this.alignmentX = DetailsUtils.getFloatFieldValue(instance, "alignmentX", 0.0f);
            this.isAlignmentYSet = DetailsUtils.getBooleanFieldValue(instance, "isAlignmentYSet", false);
            this.alignmentY = DetailsUtils.getFloatFieldValue(instance, "alignmentY", 0.0f);
            this.border = BorderBuilders.fromField(instance, "border", false, heap);
            this.flags = DetailsUtils.getIntFieldValue(instance, "flags", 0);
        }

        @Override
        protected void setupInstance(T t) {
            int n;
            Border border;
            super.setupInstance(t);
            ((JComponent)t).putClientProperty("className", this.className);
            if (this.isAlignmentXSet) {
                ((JComponent)t).setAlignmentX(this.alignmentX);
            }
            if (this.isAlignmentYSet) {
                ((JComponent)t).setAlignmentY(this.alignmentY);
            }
            if (this.border != null && (this.isPlaceholder() || !this.border.isUIResource()) && (border = (Border)this.border.createInstance()) != null) {
                ((JComponent)t).setBorder(border);
            }
            boolean bl = (this.flags & (n = 8)) == n;
            ((JComponent)t).setOpaque(bl);
        }

        @Override
        protected T createInstanceImpl() {
            this.setPlaceholder();
            return (T)new Utils.PlaceholderPanel(this.className);
        }
    }

    static class ContainerBuilder<T extends Container>
    extends ComponentBuilder<T> {
        private final boolean trackChildren;
        private final ChildrenBuilder component;

        ContainerBuilder(Instance instance, Heap heap) {
            this(instance, heap, true);
        }

        protected ContainerBuilder(Instance instance, Heap heap, boolean bl) {
            super(instance, heap);
            this.trackChildren = bl;
            this.component = this.isVisible() && bl ? ChildrenBuilder.fromField(instance, "component", heap) : null;
        }

        @Override
        protected void setupInstance(T t) {
            super.setupInstance(t);
            if (this.trackChildren) {
                ((Container)t).setLayout(null);
                ((Container)t).removeAll();
                if (this.component != null) {
                    Component[] componentArray;
                    for (Component component : componentArray = (Component[])this.component.createInstance()) {
                        ((Container)t).add(component);
                    }
                }
            }
        }

        @Override
        protected T createInstanceImpl() {
            this.setPlaceholder();
            return (T)new Utils.PlaceholderPanel(this.className);
        }
    }

    static class ComponentBuilder<T extends Component>
    extends Utils.InstanceBuilder<T> {
        protected final String className;
        private final BaseBuilders.RectangleBuilder bounds;
        private final BaseBuilders.ColorBuilder foreground;
        private final BaseBuilders.ColorBuilder background;
        private final BaseBuilders.FontBuilder font;
        private final boolean visible;
        private final boolean enabled;
        private boolean isPlaceholder = false;

        ComponentBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.className = instance.getJavaClass().getName() + "#" + instance.getInstanceNumber();
            this.bounds = new BaseBuilders.RectangleBuilder(instance, heap);
            this.foreground = BaseBuilders.ColorBuilder.fromField(instance, "foreground", heap);
            this.background = BaseBuilders.ColorBuilder.fromField(instance, "background", heap);
            this.font = BaseBuilders.FontBuilder.fromField(instance, "font", heap);
            this.visible = DetailsUtils.getBooleanFieldValue(instance, "visible", true);
            this.enabled = DetailsUtils.getBooleanFieldValue(instance, "enabled", true);
        }

        @Override
        protected void setupInstance(T t) {
            super.setupInstance(t);
            ((Component)t).setBounds((Rectangle)this.bounds.createInstance());
            if (this.foreground != null && (this.isPlaceholder || !this.foreground.isUIResource())) {
                ((Component)t).setForeground((Color)this.foreground.createInstance());
            }
            if (this.background != null && (this.isPlaceholder || !this.background.isUIResource())) {
                ((Component)t).setBackground((Color)this.background.createInstance());
            }
            if (this.font != null && (this.isPlaceholder || !this.font.isUIResource())) {
                ((Component)t).setFont((Font)this.font.createInstance());
            }
            ((Component)t).setVisible(this.visible);
            ((Component)t).setEnabled(this.enabled);
        }

        protected final boolean isVisible() {
            return this.visible;
        }

        protected final void setPlaceholder() {
            this.isPlaceholder = true;
        }

        protected final boolean isPlaceholder() {
            return this.isPlaceholder;
        }

        @Override
        protected T createInstanceImpl() {
            this.setPlaceholder();
            return (T)new Utils.PlaceholderPanel(this.className);
        }

        protected Component createPresenterImpl(T t) {
            return t;
        }

        final Component createPresenter() {
            Component component = (Component)this.createInstance();
            return component != null ? this.createPresenterImpl(component) : null;
        }
    }

    private static final class ChildrenBuilder
    extends Utils.InstanceBuilder<Component[]> {
        private final List<Utils.InstanceBuilder<Component>> component;

        ChildrenBuilder(Instance instance, Heap heap) {
            block3: {
                Object object;
                block2: {
                    super(instance, heap);
                    this.component = new ArrayList<Utils.InstanceBuilder<Component>>();
                    if (!(instance instanceof ObjectArrayInstance)) break block2;
                    List list = ((ObjectArrayInstance)instance).getValues();
                    for (Instance instance2 : list) {
                        ComponentBuilder componentBuilder;
                        if (instance2 == null || (componentBuilder = ComponentBuilders.getBuilder(instance2, heap)) == null) continue;
                        this.component.add(componentBuilder);
                    }
                    break block3;
                }
                int n = DetailsUtils.getIntFieldValue(instance, "size", 0);
                if (n <= 0 || !((object = instance.getValueOfField("elementData")) instanceof ObjectArrayInstance)) break block3;
                List list = ((ObjectArrayInstance)object).getValues();
                for (Instance instance3 : list) {
                    ComponentBuilder componentBuilder;
                    if (instance3 == null || (componentBuilder = ComponentBuilders.getBuilder(instance3, heap)) == null) continue;
                    this.component.add(componentBuilder);
                }
            }
        }

        static ChildrenBuilder fromField(Instance instance, String string, Heap heap) {
            Object object = instance.getValueOfField(string);
            if (!(object instanceof Instance)) {
                return null;
            }
            return new ChildrenBuilder((Instance)object, heap);
        }

        @Override
        protected Component[] createInstanceImpl() {
            Component[] componentArray = new Component[this.component.size()];
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i] = this.component.get(i).createInstance();
            }
            return componentArray;
        }
    }
}

