/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.AccessFlags;
import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Signature;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class FieldOrMethod
extends AccessFlags
implements Cloneable,
Node {
    private int name_index;
    private int signature_index;
    private Attribute[] attributes;
    private int attributes_count;
    private AnnotationEntry[] annotationEntries;
    private ConstantPool constant_pool;
    private String signatureAttributeString = null;
    private boolean searchedForSignatureAttribute = false;

    FieldOrMethod() {
    }

    protected FieldOrMethod(FieldOrMethod c) {
        this(c.getAccessFlags(), c.getNameIndex(), c.getSignatureIndex(), c.getAttributes(), c.getConstantPool());
    }

    @Deprecated
    protected FieldOrMethod(DataInputStream file, ConstantPool constant_pool) throws IOException, ClassFormatException {
        this((DataInput)file, constant_pool);
    }

    protected FieldOrMethod(DataInput file, ConstantPool constant_pool) throws IOException, ClassFormatException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), null, constant_pool);
        this.attributes_count = file.readUnsignedShort();
        this.attributes = new Attribute[this.attributes_count];
        for (int i = 0; i < this.attributes_count; ++i) {
            this.attributes[i] = Attribute.readAttribute(file, constant_pool);
        }
    }

    protected FieldOrMethod(int access_flags, int name_index, int signature_index, Attribute[] attributes, ConstantPool constant_pool) {
        super(access_flags);
        this.name_index = name_index;
        this.signature_index = signature_index;
        this.constant_pool = constant_pool;
        this.setAttributes(attributes);
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeShort(super.getAccessFlags());
        file.writeShort(this.name_index);
        file.writeShort(this.signature_index);
        file.writeShort(this.attributes_count);
        for (int i = 0; i < this.attributes_count; ++i) {
            this.attributes[i].dump(file);
        }
    }

    public final Attribute[] getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute[] attributes) {
        this.attributes = attributes;
        this.attributes_count = attributes != null ? attributes.length : 0;
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final void setNameIndex(int name_index) {
        this.name_index = name_index;
    }

    public final int getSignatureIndex() {
        return this.signature_index;
    }

    public final void setSignatureIndex(int signature_index) {
        this.signature_index = signature_index;
    }

    public final String getName() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        return c.getBytes();
    }

    public final String getSignature() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        return c.getBytes();
    }

    protected FieldOrMethod copy_(ConstantPool _constant_pool) {
        FieldOrMethod c = null;
        try {
            c = (FieldOrMethod)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        c.constant_pool = this.constant_pool;
        c.attributes = new Attribute[this.attributes_count];
        c.attributes_count = this.attributes_count;
        for (int i = 0; i < this.attributes_count; ++i) {
            c.attributes[i] = this.attributes[i].copy(this.constant_pool);
        }
        return c;
    }

    public AnnotationEntry[] getAnnotationEntries() {
        if (this.annotationEntries == null) {
            this.annotationEntries = AnnotationEntry.createAnnotationEntries(this.getAttributes());
        }
        return this.annotationEntries;
    }

    public final String getGenericSignature() {
        if (!this.searchedForSignatureAttribute) {
            boolean found = false;
            for (int i = 0; !found && i < this.attributes.length; ++i) {
                if (!(this.attributes[i] instanceof Signature)) continue;
                this.signatureAttributeString = ((Signature)this.attributes[i]).getSignature();
                found = true;
            }
            this.searchedForSignatureAttribute = true;
        }
        return this.signatureAttributeString;
    }
}

