/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;

public class Kernel
implements Cloneable {
    private int width;
    private int height;
    private int xOrigin;
    private int yOrigin;
    private float[] data;

    private static native void initIDs();

    public Kernel(int n, int n2, float[] fArray) {
        this.width = n;
        this.height = n2;
        this.xOrigin = n - 1 >> 1;
        this.yOrigin = n2 - 1 >> 1;
        int n3 = n * n2;
        if (fArray.length < n3) {
            throw new IllegalArgumentException("Data array too small (is " + fArray.length + " and should be " + n3);
        }
        this.data = new float[n3];
        System.arraycopy(fArray, 0, this.data, 0, n3);
    }

    public final int getXOrigin() {
        return this.xOrigin;
    }

    public final int getYOrigin() {
        return this.yOrigin;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final float[] getKernelData(float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.data.length];
        } else if (fArray.length < this.data.length) {
            throw new IllegalArgumentException("Data array too small (should be " + this.data.length + " but is " + fArray.length + " )");
        }
        System.arraycopy(this.data, 0, fArray, 0, this.data.length);
        return fArray;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    static {
        ColorModel.loadLibraries();
        Kernel.initIDs();
    }
}

