/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.console.historicaldata.HistoricalDataPlugin;
import com.jrockit.mc.console.historicaldata.editors.HistoricalDataEditorInput;
import com.jrockit.mc.console.historicaldata.editors.HistoricalDataTab;
import com.jrockit.mc.ui.MCPathEditorInput;
import com.jrockit.mc.ui.formpage.internal.MCFormEditor;
import java.io.File;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class HistoricalDataEditor
extends MCFormEditor {
    public static final String EDITOR_ID = "com.jrockit.mc.console.historicaldata.editors.HistoricalDataEditor";
    private HistoricalDataTab historicalDataEditorPage;

    public int promptToSaveOnClose() {
        return 1;
    }

    protected void addPages() {
        try {
            File file = MCPathEditorInput.getFile((IEditorInput)this.getEditorInput());
            if (file != null) {
                this.addPageFromFile(file);
            } else if (this.getEditorInput() instanceof HistoricalDataEditorInput) {
                this.addPageFromEditorInput((HistoricalDataEditorInput)this.getEditorInput());
            }
            if (this.getPageCount() > 0) {
                this.setPageImage(0, HistoricalDataPlugin.getDefault().getImage("historic-data-16.gif"));
            }
        }
        catch (PartInitException e) {
            HistoricalDataPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not create tab page");
        }
    }

    private void addPageFromEditorInput(HistoricalDataEditorInput input) throws PartInitException {
        String uid = input.getUid();
        if (uid != null) {
            this.addPage(this.getHistoricalDataEditorPage(uid));
        }
    }

    private void addPageFromFile(File logFile) throws PartInitException {
        File dataDir;
        File attributeDir = logFile.getParentFile();
        if (attributeDir != null && (dataDir = attributeDir.getParentFile()) != null) {
            this.addPage(this.getHistoricalDataEditorPage(dataDir));
        }
    }

    private IFormPage getHistoricalDataEditorPage(File fileName) {
        if (this.historicalDataEditorPage == null) {
            this.historicalDataEditorPage = new HistoricalDataTab((FormEditor)this, null, fileName);
        }
        return this.historicalDataEditorPage;
    }

    private IFormPage getHistoricalDataEditorPage(String uid) {
        if (this.historicalDataEditorPage == null) {
            this.historicalDataEditorPage = new HistoricalDataTab((FormEditor)this, uid, null);
        }
        return this.historicalDataEditorPage;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

