/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.celleditors;

import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.ui.misc.ControlDecorationToolkit;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ClearableTextCellEditor
extends TextCellEditor {
    private final ControlDecoration infoDecorator;

    public ClearableTextCellEditor(Composite parent) {
        super(parent);
        this.infoDecorator = ControlDecorationToolkit.createInfoDecorator((Control)this.text);
    }

    public void activate() {
        super.activate();
        String info = this.getInfoText();
        if (info != null) {
            this.infoDecorator.setDescriptionText(info);
            this.infoDecorator.show();
        } else {
            this.infoDecorator.hide();
        }
    }

    protected boolean allowClear() {
        return true;
    }

    protected String getInfoText() {
        return this.allowClear() ? Messages.ClearableTextCellEditor_PRESS_BACKSPACE_TO_CLEAR_VALUE : null;
    }

    protected void clear() {
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\b' && this.text.getText().length() == 0 && this.allowClear()) {
            this.clear();
            this.fireApplyEditorValue();
            this.deactivate();
        } else {
            super.keyReleaseOccured(keyEvent);
        }
    }
}

