/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.IOptionConstraint;
import com.jrockit.mc.rjmx.services.flr.IOptionDescriptor;
import com.jrockit.mc.rjmx.services.flr.OpenTypeConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.internal.ContentMashup;
import com.jrockit.mc.rjmx.services.flr.internal.Messages;
import com.jrockit.mc.rjmx.services.flr.internal.OptionMetadata;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public final class RecordingOptionsToolkit {
    public static final IOptionDescriptor OPT_NAME;
    public static final IOptionDescriptor OPT_TO_DISK;
    public static final IOptionDescriptor OPT_START_TIME;
    public static final IOptionDescriptor OPT_DURATION;
    public static final IOptionDescriptor OPT_MAX_SIZE;
    public static final IOptionDescriptor OPT_MAX_AGE;
    public static final IOptionDescriptor OPT_DESTINATION_FILE;
    public static final IOptionDescriptor OPT_DESTINATION_COMPRESSED;
    private static final Map<String, IOptionDescriptor> DESCRIPTORS_BY_KEY;
    private static final String[] NAMES;
    private static final CompositeType OPTIONS_TYPE;

    static {
        HashMap<String, IOptionDescriptor> map = new HashMap<String, IOptionDescriptor>();
        OPT_NAME = RecordingOptionsToolkit.add(map, "name", Messages.RecordingOptionsToolkit_RECORDING_NAME, ContentMashup.TEXT, Messages.RecordingOptionsToolkit_DEFAULT_RECORDING_NAME);
        OPT_TO_DISK = RecordingOptionsToolkit.add(map, "toDisk", Messages.RecordingOptionsToolkit_TO_DISK, ContentMashup.BOOLEAN, Boolean.FALSE);
        OPT_START_TIME = RecordingOptionsToolkit.add(map, "startTime", Messages.RecordingOptionsToolkit_START_TIME, ContentMashup.DATE, new Date());
        OPT_DURATION = RecordingOptionsToolkit.add(map, "duration", Messages.RecordingOptionsToolkit_DURATION, ContentMashup.MILLISECONDS, 0L, 10000000000L, 120000L);
        OPT_MAX_SIZE = RecordingOptionsToolkit.add(map, "maxSize", Messages.RecordingOptionsToolkit_MAXIMUM_SIZE, ContentMashup.BYTES, 0L, 0x40000000L, 0L);
        OPT_MAX_AGE = RecordingOptionsToolkit.add(map, "maxAge", Messages.RecordingOptionsToolkit_MAXIMUM_AGE, ContentMashup.MILLISECONDS, 0L, Long.MAX_VALUE, 0L);
        OPT_DESTINATION_FILE = RecordingOptionsToolkit.add(map, "destinationFile", Messages.RecordingOptionsToolkit_DESTINATION_FILE, ContentMashup.FILE_NAME, "recording.jfr.gz");
        OPT_DESTINATION_COMPRESSED = RecordingOptionsToolkit.add(map, "destinationCompressed", Messages.RecordingOptionsToolkit_DESTINATION_COMPRESSED, ContentMashup.BOOLEAN, Boolean.TRUE);
        DESCRIPTORS_BY_KEY = Collections.unmodifiableMap(map);
        NAMES = new String[map.size()];
        OPTIONS_TYPE = RecordingOptionsToolkit.createCompositeType("RecordingOptions", "Recording Options", DESCRIPTORS_BY_KEY.values(), NAMES);
    }

    private static <T extends Comparable<T>> IOptionDescriptor add(Map<String, IOptionDescriptor> map, String simpleKey, String description, ContentMashup<T> contentType, T defaultValue) {
        return RecordingOptionsToolkit.add(map, simpleKey, description, contentType, null, null, defaultValue);
    }

    private static <T extends Comparable<T>> IOptionDescriptor add(Map<String, IOptionDescriptor> map, String simpleKey, String description, ContentMashup<T> contentType, T min, T max, T defaultValue) {
        OptionMetadata<T> desc = new OptionMetadata<T>(simpleKey, contentType, description, min, max, defaultValue);
        map.put(RecordingOptionsToolkit.qualifiedKey(simpleKey), desc);
        return desc;
    }

    private static CompositeType createCompositeType(String name, String description, Collection<IOptionDescriptor> descriptors, String[] names) {
        int len = descriptors.size();
        String[] descriptions = new String[len];
        OpenType[] openTypes = new OpenType[len];
        int i = 0;
        for (IOptionDescriptor descriptor : descriptors) {
            names[i] = descriptor.getKey();
            descriptions[i] = descriptor.getDescription();
            openTypes[i] = ((OptionMetadata)descriptor).getOpenType();
            ++i;
        }
        try {
            return new CompositeType("RecordingOptions", "Recording Options", names, descriptions, openTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String qualifiedKey(String simpleKey) {
        return "recordingOption." + simpleKey;
    }

    private RecordingOptionsToolkit() {
        throw new AssertionError((Object)"Not to be instantiatied!");
    }

    public static CompositeData getRecordingOptions(Map<String, ?> settings) throws OpenDataException {
        Object[] values = new Object[NAMES.length];
        int i = 0;
        while (i < NAMES.length) {
            values[i] = settings.get(RecordingOptionsToolkit.qualifiedKey(NAMES[i]));
            ++i;
        }
        return new CompositeDataSupport(OPTIONS_TYPE, NAMES, values);
    }

    public static Map<String, IOptionDescriptor> getAvailableRecordingOptions() {
        return DESCRIPTORS_BY_KEY;
    }

    public static IOptionConstraint<?> getRecordingOptionConstraint(String propertyKey) {
        IOptionDescriptor desc = DESCRIPTORS_BY_KEY.get(propertyKey);
        return desc != null ? desc.getConstraint() : null;
    }

    public static Map<String, IConvertibleValue<?>> getRecordingOptions(CompositeData recordingOptions) throws FlightRecorderException {
        HashMap options = new HashMap();
        for (String compositeKey : recordingOptions.getCompositeType().keySet()) {
            String propertyKey = RecordingOptionsToolkit.qualifiedKey(compositeKey);
            OptionMetadata descriptor = DESCRIPTORS_BY_KEY.get(propertyKey);
            if (descriptor == null) {
                descriptor = RecordingOptionsToolkit.createUnknownOption(compositeKey, recordingOptions);
            }
            options.put(propertyKey, OpenTypeConvertibleValue.createWithCast(descriptor.getConstraint(), recordingOptions.get(compositeKey)));
        }
        return options;
    }

    private static <T extends Comparable<T>> OptionMetadata<T> createUnknownOption(String compositeKey, CompositeData recordingOptions) throws FlightRecorderException {
        String propertyKey = RecordingOptionsToolkit.qualifiedKey(compositeKey);
        Object value = recordingOptions.get(compositeKey);
        String description = recordingOptions.getCompositeType().getDescription(propertyKey);
        OpenType<?> openType = recordingOptions.getCompositeType().getType(propertyKey);
        try {
            Class<?> type = Class.forName(openType.getClassName());
            if (!Comparable.class.isAssignableFrom(type)) {
                throw new FlightRecorderException("Non-Comparable Open Type for key " + propertyKey);
            }
            return new OptionMetadata<Comparable>(propertyKey, type, openType, description, (Comparable)type.cast(value));
        }
        catch (ClassNotFoundException e) {
            throw new FlightRecorderException("Could not decode the class for key " + propertyKey, e);
        }
    }

    public static String getName(Map<String, ?> recordingOptions) {
        return (String)recordingOptions.get("recordingOption.name");
    }
}

