/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.IOException;
import org.apache.derby.impl.io.DirFile;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;

abstract class BaseStorageFactory
implements StorageFactory {
    String home;
    protected StorageFile tempDir;
    protected String tempDirPath;
    protected String dataDirectory;
    protected String separatedDataDirectory;
    protected String uniqueName;
    protected String canonicalName;
    private static final String TEMP_DIR_PREFIX = "derbytmp_";

    BaseStorageFactory() {
    }

    public void init(String string, String string2, String string3, String string4) throws IOException {
        if (string2 != null) {
            this.dataDirectory = string2;
            this.separatedDataDirectory = string2 + this.getSeparator();
        }
        this.home = string;
        this.uniqueName = string4;
        this.tempDirPath = string3;
        this.doInit();
    }

    abstract void doInit() throws IOException;

    public void shutdown() {
    }

    public String getCanonicalName() throws IOException {
        return this.canonicalName;
    }

    public void setCanonicalName(String string) {
        this.canonicalName = string;
    }

    public StorageFile newStorageFile(String string) {
        if (string != null && this.tempDirPath != null && string.startsWith(this.tempDirPath)) {
            return new DirFile(string);
        }
        return this.newPersistentFile(string);
    }

    public StorageFile newStorageFile(String string, String string2) {
        if (string == null) {
            return this.newStorageFile(string2);
        }
        if (this.tempDirPath != null && string.startsWith(this.tempDirPath)) {
            return new DirFile(string, string2);
        }
        return this.newPersistentFile(string, string2);
    }

    public StorageFile newStorageFile(StorageFile storageFile, String string) {
        if (storageFile == null) {
            return this.newStorageFile(string);
        }
        if (string == null) {
            return storageFile;
        }
        if (this.tempDirPath != null && storageFile.getPath().startsWith(this.tempDirPath)) {
            return new DirFile((DirFile)storageFile, string);
        }
        return this.newPersistentFile(storageFile, string);
    }

    abstract StorageFile newPersistentFile(String var1);

    abstract StorageFile newPersistentFile(String var1, String var2);

    abstract StorageFile newPersistentFile(StorageFile var1, String var2);

    public char getSeparator() {
        return File.separatorChar;
    }

    public StorageFile getTempDir() {
        return this.tempDir;
    }

    public boolean isFast() {
        return false;
    }

    public boolean isReadOnlyDatabase() {
        return true;
    }

    public boolean supportsRandomAccess() {
        return false;
    }

    void createTempDir() throws IOException {
        if (this.uniqueName == null) {
            return;
        }
        this.tempDir = this.tempDirPath != null ? new DirFile(this.tempDirPath, TEMP_DIR_PREFIX.concat(this.uniqueName)) : (this.isReadOnlyDatabase() ? new DirFile(this.readOnlyTempRoot(), TEMP_DIR_PREFIX.concat(this.uniqueName)) : new DirFile(this.canonicalName, "tmp"));
        this.tempDir.deleteAll();
        this.tempDir.mkdirs();
        this.tempDirPath = this.tempDir.getPath();
    }

    private String readOnlyTempRoot() throws IOException {
        File file = File.createTempFile("derby", "tmp");
        String string = file.getParent();
        file.delete();
        return string;
    }

    public int getStorageFactoryVersion() {
        return 1;
    }

    public StorageFile createTemporaryFile(String string, String string2) throws IOException {
        File file = File.createTempFile(string, string2, new File(this.getTempDir().getPath()));
        return this.newStorageFile(this.getTempDir(), file.getName());
    }
}

