/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingTemplateControlView;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class RecordingEventOptionsWizardPage
extends WizardPage
implements Observer {
    public static final String PAGE_NAME = "recordingEventOptionsWizard";
    private static final int WIZARD_STAGE = 1;
    private final RecordingWizardModel m_model;
    private RecordingTemplateControlView m_controlView;

    public RecordingEventOptionsWizardPage(RecordingWizardModel model) {
        super(PAGE_NAME);
        this.m_model = model;
        this.setImageDescriptor(ControlPanel.getDefault().getMCImageDescriptor("startjfrwiz.gif"));
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setDescription(Messages.START_RECORDING_EVENT_OPTIONS_WIZARD_PAGE_DESCRIPTION);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        this.m_controlView = new RecordingTemplateControlView(container);
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IRecordingConfiguration ourConfig = this.m_model.getCurrentConfigurationAt(1);
            this.setTitle(NLS.bind((String)Messages.START_RECORDING_EVENT_OPTIONS_WIZARD_PAGE_TITLE, (Object)this.m_model.getCurrentConfigurationAt(1).getName()));
            XMLModel ourModel = ((RecordingTemplate)ourConfig).getXMLModel();
            IRecordingConfiguration activeConfig = this.m_model.getActiveConfiguration();
            if (activeConfig != ourConfig) {
                if (!activeConfig.equalSettings((IEventSettingsHolder)ourConfig)) {
                    this.setMessage(Messages.START_RECORDING_WIZARD_LATER_STAGE_CHANGE_WARNING, 2);
                } else {
                    this.setMessage(null);
                }
                ourModel.setDirty(false);
                ourModel.addObserver((Observer)this);
            } else {
                this.setMessage(null);
            }
            this.m_controlView.cleanCreate(ourModel);
        }
        super.setVisible(visible);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof XMLModel) {
            this.m_model.flushConfigurationsBeyond(1);
            this.setMessage(null);
            o.deleteObserver(this);
        }
    }
}

