/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.designelement;

import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.designelement.IDesignElement;
import com.jrockit.mc.components.ui.design.designelement.SelectionContext;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.ui.misc.SelectionProvider;
import com.jrockit.mc.ui.site.IServiceRegistry;
import com.jrockit.mc.ui.site.SectionSite;
import com.jrockit.mc.ui.site.SiteFocusListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;

abstract class AbstractElement
implements IDesignElement {
    private final List<IDesignElement> m_children = new ArrayList<IDesignElement>();
    private Composite m_control;
    private IDesignElement m_parent;
    private SectionSite m_site;
    private SelectionProvider m_selectionProvider;
    private IServiceLocator m_locator;
    private LayoutItem m_layoutItem;
    private SelectionContext m_selectionContext;

    AbstractElement() {
    }

    @Override
    public Composite getControl() {
        return this.m_control;
    }

    @Override
    public final void create(IDesignElement parent, LayoutItem layoutItem, IServiceLocator locator) {
        this.m_parent = parent;
        this.m_layoutItem = layoutItem;
        this.m_locator = locator;
        this.m_control = this.createControl(parent.getControl());
        this.m_site = new SectionSite("layoutItem", (IWorkbenchPartSite)locator.getService("workbenchPartSite"), (IServiceRegistry)locator);
        this.m_selectionProvider = new SelectionProvider();
        this.m_site.setSelectionProvider((ISelectionProvider)this.m_selectionProvider);
        this.m_selectionContext = locator.getService(SelectionContext.class);
        this.m_control.addFocusListener((FocusListener)new SiteFocusListener(this.m_site));
    }

    protected abstract Composite createControl(Composite var1);

    @Override
    public void addElement(IDesignElement e) {
        this.m_children.add(e);
    }

    @Override
    public IServiceLocator getServiceLocator() {
        return this.m_locator;
    }

    @Override
    public void setSelected() {
        this.m_selectionContext.setSelectedObject(this);
        ISelection s = this.getProvider().getSelection();
        if (s instanceof IStructuredSelection) {
            this.getProvider().setSelection((ISelection)new StructuredSelection((Object)this));
        }
        this.show();
    }

    @Override
    public void show() {
        IDesignElement parent = this.getParentElement();
        if (parent != null) {
            parent.showChild(this);
            parent.show();
        }
    }

    @Override
    public void showChild(IDesignElement child) {
    }

    public void setLayoutItem(LayoutItem layoutItem) {
        this.m_layoutItem = layoutItem;
    }

    @Override
    public LayoutItem getLayoutItem() {
        return this.m_layoutItem;
    }

    protected final void setParent(IDesignElement parent) {
        this.m_parent = parent;
    }

    protected final void setControl(Composite control) {
        this.m_control = control;
    }

    @Override
    public List<IDesignElement> getChildren() {
        return this.m_children;
    }

    @Override
    public IDesignElement getParentElement() {
        return this.m_parent;
    }

    @Override
    public boolean isSelected() {
        return this.m_selectionContext.getSelectedObject() == this;
    }

    private ISelectionProvider getProvider() {
        return this.m_selectionProvider;
    }

    @Override
    public void refresh() {
        for (IDesignElement child : this.getChildren()) {
            child.refresh();
        }
        this.getControl().layout(true, true);
        this.getControl().redraw();
    }

    public int hashCode() {
        return this.getLayoutItem().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof IDesignElement) {
            IDesignElement that = (IDesignElement)o;
            return this.getLayoutItem().equals(that.getLayoutItem());
        }
        return false;
    }
}

