/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.SystemUtils;
import com.sun.deploy.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;

public class AppInfo {
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_APPLICATION = 1;
    public static final int TYPE_APPLET = 2;
    public static final int TYPE_LIBRARY = 3;
    public static final int TYPE_INSTALLER = 4;
    public static final int ICON_SIZE = 48;
    public static final int TITLE_MAX = 40;
    public static final int VENDOR_MAX = 40;
    public static final int URL_MAX = 80;
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_SANDBOX = 1;
    public static final int MODE_ENHANCED = 2;
    private static final String JNLP_FROM_UNKNOWN_SOURCE = "tag93872907981234for.jnlp";
    private int type = 0;
    private String title = null;
    private String vendor = null;
    private URL from = null;
    private URL mainJNLP = null;
    private URL documentBase = null;
    private URL iconRef = null;
    private String iconVersion = null;
    private boolean desktopHint = false;
    private boolean menuHint = false;
    private String submenu = null;
    private AssociationDesc[] associations = new AssociationDesc[0];
    private int security = 0;
    private URL lapURL = null;
    private boolean permissionAttr = false;
    private boolean hasSignedJNLP = false;
    private boolean futureBlockPermission = true;
    private boolean futureBlockSelfsigned = true;
    private boolean futureBlockUnsigned = true;
    private String appArgs = null;
    private URL emURL = null;
    private String emVersion = null;
    private String hashString = null;
    private boolean permissionAttrOverride = false;

    public AppInfo() {
        this.type = 2;
        Object object = ToolkitStore.get().getAppContext().get("deploy.trust.decider.app.name");
        if (object != null) {
            this.title = object.toString();
        }
    }

    public AppInfo(int n, String string, String string2, URL uRL, URL uRL2, URL uRL3, String string3, boolean bl, boolean bl2, String string4, AssociationDesc[] associationDescArray) {
        this.type = n;
        this.title = string;
        this.vendor = string2;
        this.from = uRL;
        this.mainJNLP = uRL2;
        this.iconRef = uRL3;
        this.iconVersion = string3;
        this.desktopHint = bl;
        this.menuHint = bl2;
        this.submenu = string4;
        this.associations = associationDescArray;
        this.lapURL = uRL;
    }

    public AppInfo(AppInfo appInfo) {
        this.type = appInfo.type;
        this.title = appInfo.title;
        this.vendor = appInfo.vendor;
        this.from = appInfo.from;
        this.mainJNLP = appInfo.mainJNLP;
        this.documentBase = appInfo.documentBase;
        this.iconRef = appInfo.iconRef;
        this.iconVersion = appInfo.iconVersion;
        this.desktopHint = appInfo.desktopHint;
        this.menuHint = appInfo.menuHint;
        this.submenu = appInfo.submenu;
        this.associations = appInfo.associations;
        this.security = appInfo.security;
        this.lapURL = appInfo.lapURL;
        this.permissionAttr = appInfo.permissionAttr;
        this.hasSignedJNLP = appInfo.hasSignedJNLP;
        this.futureBlockPermission = appInfo.futureBlockPermission;
        this.futureBlockSelfsigned = appInfo.futureBlockSelfsigned;
        this.futureBlockUnsigned = appInfo.futureBlockUnsigned;
        this.hashString = appInfo.hashString;
        this.appArgs = appInfo.appArgs;
        this.emURL = appInfo.emURL;
        this.emVersion = appInfo.emVersion;
        this.permissionAttrOverride = appInfo.permissionAttrOverride;
    }

    private String limitString(String string, int n) {
        if (string != null && string.length() > n) {
            return string.substring(0, n - 4) + " ...";
        }
        return string;
    }

    public int getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVendor() {
        return this.vendor;
    }

    public URL getFrom() {
        return this.from;
    }

    public URL getMainJNLP() {
        return this.mainJNLP;
    }

    public URL getDocumentBase() {
        return this.documentBase;
    }

    public URL getIconRef() {
        return this.iconRef;
    }

    public String getIconVersion() {
        return this.iconVersion;
    }

    public boolean getDesktopHint() {
        return this.desktopHint;
    }

    public boolean getMenuHint() {
        return this.menuHint;
    }

    public String getSubmenu() {
        return this.submenu;
    }

    public AssociationDesc[] getAssociations() {
        return this.associations;
    }

    public int getSecurity() {
        return this.security;
    }

    public URL getLapURL() {
        return this.lapURL;
    }

    public boolean hasSignedJNLP() {
        return this.hasSignedJNLP;
    }

    public String getHashString() {
        if (this.hashString == null) {
            this.hashString = "Main:";
            if (this.emURL != null) {
                try {
                    final Resource resource = ResourceProvider.get().getCachedResource(this.emURL, this.emVersion);
                    if (resource != null) {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                AppInfo.this.hashString = AppInfo.this.hashString + SystemUtils.getFileChecksum(resource.getDataFile(), null);
                                return null;
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    Trace.ignored(exception);
                }
            }
            if (this.appArgs != null) {
                this.hashString = this.hashString + "JNLP:" + SystemUtils.getChecksum(this.appArgs.getBytes(), null);
            }
        }
        return this.hashString;
    }

    public String getDisplayTitle() {
        return this.limitString(this.title, 40);
    }

    public String getDisplayVendor() {
        return this.limitString(this.vendor, 40);
    }

    public String getDisplayFrom() {
        return AppInfo.truncatedURL(this.from);
    }

    public String getDisplayMainJNLP() {
        if (this.isJNLPSourceUnknown()) {
            return ResourceManager.getMessage("deployment.dialog.jnlp.downloaded");
        }
        return AppInfo.truncatedURL(this.mainJNLP);
    }

    public String getDisplayMainJNLPTooltip() {
        String string = "";
        if (this.isJNLPSourceUnknown()) {
            string = ResourceManager.getMessage("deployment.dialog.jnlp.downloaded.tooltip");
        } else if (this.mainJNLP != null) {
            string = this.getMainJNLP().toString();
        }
        return string;
    }

    private boolean isJNLPSourceUnknown() {
        return this.mainJNLP != null && this.mainJNLP.getProtocol().equals("file") && this.mainJNLP.getFile().endsWith(JNLP_FROM_UNKNOWN_SOURCE);
    }

    public String getDisplayDocumentBase() {
        return AppInfo.truncatedURL(this.documentBase);
    }

    public boolean shouldDisplayMainJNLP() {
        if (this.mainJNLP == null || "file".equals(this.mainJNLP.getProtocol()) && "".equals(this.mainJNLP.getHost()) && !this.mainJNLP.getPath().endsWith(JNLP_FROM_UNKNOWN_SOURCE)) {
            return false;
        }
        return !URLUtil.sameBase(this.from, this.mainJNLP);
    }

    public boolean shouldDisplayDocumentBase() {
        if (this.documentBase == null || "file".equals(this.documentBase.getProtocol()) && "".equals(this.documentBase.getHost())) {
            return false;
        }
        if (this.mainJNLP == null) {
            return !URLUtil.sameBase(this.from, this.documentBase);
        }
        return !URLUtil.sameBase(this.from, this.documentBase) && !URLUtil.sameBase(this.mainJNLP, this.documentBase);
    }

    public boolean isMultiHost() {
        return this.shouldDisplayDocumentBase() || this.shouldDisplayMainJNLP();
    }

    public URL[] getMultiHostUrls() {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        linkedList.add(this.getFrom());
        if (this.shouldDisplayMainJNLP()) {
            linkedList.add(this.getMainJNLP());
        }
        if (this.shouldDisplayDocumentBase()) {
            linkedList.add(this.getDocumentBase());
        }
        return linkedList.toArray(new URL[linkedList.size()]);
    }

    public static String truncatedURL(URL uRL) {
        int n;
        if (uRL == null) {
            return "";
        }
        String string = uRL.getProtocol() + "://" + uRL.getHost();
        int n2 = uRL.getPort();
        if (n2 != -1) {
            string = string + ":" + Integer.toString(n2);
        }
        if ((n = string.length()) <= 80) {
            return string;
        }
        return string.substring(0, 77) + "...";
    }

    public String toString() {
        return "Appinfo:\ntype = " + this.type + "\n" + "title = " + this.title + "\n" + "vendor = " + this.vendor + "\n" + "from = " + this.from + "\n" + "security = " + this.security + "\n" + "lapURL = " + this.lapURL + "\n" + "appArgs = " + this.appArgs;
    }

    public boolean hasPermissionAttr() {
        if (this.permissionAttrOverride) {
            return true;
        }
        return this.permissionAttr;
    }

    public void setPermissionAttrOverride() {
        this.permissionAttrOverride = true;
    }

    public void unsetPermissionAttrOverride() {
        this.permissionAttrOverride = false;
    }

    public void setPermissionAttr(boolean bl) {
        this.permissionAttr = bl;
    }

    public void setFutureBlockPermission(boolean bl) {
        this.futureBlockPermission = bl;
    }

    public boolean getFutureBlockPermission() {
        return this.futureBlockPermission;
    }

    public void setFutureBlockSelfsigned(boolean bl) {
        this.futureBlockSelfsigned = bl;
    }

    public boolean getFutureBlockSelfsigned() {
        return this.futureBlockSelfsigned;
    }

    public void setFutureBlockUnsigned(boolean bl) {
        this.futureBlockUnsigned = bl;
    }

    public boolean getFutureBlockUnsigned() {
        return this.futureBlockUnsigned;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public void setFrom(URL uRL) {
        this.from = uRL;
    }

    public void setMainJNLP(URL uRL) {
        this.mainJNLP = uRL;
    }

    public void setDocumentBase(URL uRL) {
        this.documentBase = uRL;
    }

    public void setIconRef(URL uRL) {
        this.iconRef = uRL;
    }

    public void setIconVersion(String string) {
        this.iconVersion = string;
    }

    public void setDesktopHint(boolean bl) {
        this.desktopHint = bl;
    }

    public void setMenuHint(boolean bl) {
        this.menuHint = bl;
    }

    public void setSubmenu(String string) {
        this.submenu = string;
    }

    public void setAssociations(AssociationDesc[] associationDescArray) {
        this.associations = associationDescArray;
    }

    public void setSecurity(int n) {
        this.security = n;
    }

    public void setLapURL(URL uRL) {
        this.lapURL = uRL;
    }

    public void setSignedJNLPL(boolean bl) {
        this.hasSignedJNLP = bl;
    }

    public void setAppArgs(String string) {
        this.appArgs = string;
    }

    public void setEMURL(URL uRL) {
        this.emURL = uRL;
    }

    public void setEMVersion(String string) {
        this.emVersion = string;
    }

    public static AppInfo createSingleHostAppInfo(AppInfo appInfo) {
        AppInfo appInfo2 = new AppInfo(appInfo);
        appInfo2.setDocumentBase(null);
        appInfo2.setMainJNLP(null);
        return appInfo2;
    }

    public static URL getJNLPFromUnknownSource() {
        try {
            return new File("", JNLP_FROM_UNKNOWN_SOURCE).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }
}

