/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.ui.misc.IntFieldEditor;
import com.jrockit.mc.ui.misc.SubclassableRadioGroupFieldEditor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class NestedRadioGroupFieldEditor
extends SubclassableRadioGroupFieldEditor {
    protected FieldEditor[] editors;
    protected Object[] editorParams;
    protected int selectedIndex;

    public NestedRadioGroupFieldEditor(String name, String labelText, String[][] labelAndValues, Object[] editorParams, Composite parent) {
        super(name, labelText, 3, labelAndValues, parent, true);
        this.editorParams = editorParams;
        if (labelAndValues.length != editorParams.length) {
            throw new IllegalArgumentException("The arrays labelAndValues and editorParams must have the same length");
        }
        this.editors = new FieldEditor[editorParams.length];
        this.createControl(parent);
    }

    @Override
    public Composite getRadioBoxControl(Composite parent) {
        if (this.radioBox == null) {
            Font font = parent.getFont();
            if (this.useGroup) {
                Group group = new Group(parent, 0);
                group.setFont(font);
                String text = this.getLabelText();
                if (text != null) {
                    group.setText(text);
                }
                this.radioBox = group;
                GridLayout layout = new GridLayout();
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.radioBox.setLayout((Layout)layout);
            } else {
                this.radioBox = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.marginWidth = 0;
                layout.marginHeight = 0;
                layout.horizontalSpacing = 8;
                layout.numColumns = this.numColumns;
                this.radioBox.setLayout((Layout)layout);
                this.radioBox.setFont(font);
            }
            this.radioButtons = new Button[this.labelsAndValues.length];
            int i = 0;
            while (i < this.labelsAndValues.length) {
                Button radio;
                this.radioButtons[i] = radio = new Button(this.radioBox, 16400);
                String[] labelAndValue = this.labelsAndValues[i];
                radio.setText(labelAndValue[0]);
                radio.setData((Object)labelAndValue[1]);
                radio.setFont(font);
                GridData data = new GridData(768);
                if (labelAndValue.length > 3) {
                    if (this.editorParams[i] instanceof int[]) {
                        int[] params = (int[])this.editorParams[i];
                        IntFieldEditor intEditor = new IntFieldEditor(labelAndValue[2], labelAndValue[3], this.radioBox, params[0]);
                        if (params.length > 2) {
                            intEditor.setValidRange(params[1], params[2]);
                        }
                        intEditor.setEnabled(false, this.radioBox);
                        intEditor.adjustForNumColumns(this.numColumns - 1);
                        this.editors[i] = intEditor;
                    }
                    data.horizontalSpan = 1;
                } else {
                    data.horizontalSpan = this.numColumns;
                }
                radio.setLayoutData((Object)data);
                radio.addSelectionListener((SelectionListener)new NestedEnableDisabler(i));
                ++i;
            }
            this.radioBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    NestedRadioGroupFieldEditor.this.radioBox = null;
                    NestedRadioGroupFieldEditor.this.radioButtons = null;
                }
            });
        } else {
            this.checkParent((Control)this.radioBox, parent);
        }
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 8;
        layout.numColumns = this.numColumns;
        this.radioBox.setLayout((Layout)layout);
        return this.radioBox;
    }

    @Override
    protected void updateValue(String selectedValue) {
        super.updateValue(selectedValue);
        if (this.radioButtons == null) {
            return;
        }
        int i = 0;
        while (i < this.editors.length) {
            if (this.editors[i] != null) {
                boolean selected = this.radioButtons[i].getSelection();
                this.editors[i].setEnabled(selected, this.radioBox);
                if (selected) {
                    this.selectedIndex = i;
                }
            }
            ++i;
        }
    }

    @Override
    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        int i = 0;
        while (i < this.editors.length) {
            if (this.editors[i] != null) {
                this.editors[i].setEnabled(enabled && i == this.selectedIndex, this.radioBox);
            }
            ++i;
        }
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        FieldEditor[] fieldEditorArray = this.editors;
        int n = this.editors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldEditor editor = fieldEditorArray[n2];
            if (editor != null) {
                editor.load();
            }
            ++n2;
        }
    }

    @Override
    protected void doLoadDefault() {
        super.doLoadDefault();
        FieldEditor[] fieldEditorArray = this.editors;
        int n = this.editors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldEditor editor = fieldEditorArray[n2];
            if (editor != null) {
                editor.loadDefault();
            }
            ++n2;
        }
    }

    @Override
    protected void doStore() {
        super.doStore();
        FieldEditor[] fieldEditorArray = this.editors;
        int n = this.editors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldEditor editor = fieldEditorArray[n2];
            if (editor != null) {
                editor.store();
            }
            ++n2;
        }
    }

    public void setPage(DialogPage dialogPage) {
        super.setPage(dialogPage);
        FieldEditor[] fieldEditorArray = this.editors;
        int n = this.editors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldEditor editor = fieldEditorArray[n2];
            if (editor != null) {
                editor.setPage(dialogPage);
            }
            ++n2;
        }
    }

    public void setPropertyChangeListener(IPropertyChangeListener listener) {
        super.setPropertyChangeListener(listener);
        FieldEditor[] fieldEditorArray = this.editors;
        int n = this.editors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldEditor editor = fieldEditorArray[n2];
            if (editor != null) {
                editor.setPropertyChangeListener(listener);
            }
            ++n2;
        }
    }

    public void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        FieldEditor[] fieldEditorArray = this.editors;
        int n = this.editors.length;
        int n2 = 0;
        while (n2 < n) {
            FieldEditor editor = fieldEditorArray[n2];
            if (editor != null) {
                editor.setPreferenceStore(store);
            }
            ++n2;
        }
    }

    protected class NestedEnableDisabler
    extends SelectionAdapter {
        private final int index;

        public NestedEnableDisabler(int index) {
            this.index = index;
        }

        public void widgetSelected(SelectionEvent event) {
            String oldValue = NestedRadioGroupFieldEditor.this.value;
            NestedRadioGroupFieldEditor.this.value = (String)event.widget.getData();
            NestedRadioGroupFieldEditor.this.setPresentsDefaultValue(false);
            if (NestedRadioGroupFieldEditor.this.editors[NestedRadioGroupFieldEditor.this.selectedIndex] != null) {
                NestedRadioGroupFieldEditor.this.editors[NestedRadioGroupFieldEditor.this.selectedIndex].setEnabled(false, NestedRadioGroupFieldEditor.this.radioBox);
            }
            if (NestedRadioGroupFieldEditor.this.editors[this.index] != null) {
                NestedRadioGroupFieldEditor.this.editors[this.index].setEnabled(true, NestedRadioGroupFieldEditor.this.radioBox);
            }
            NestedRadioGroupFieldEditor.this.selectedIndex = this.index;
            NestedRadioGroupFieldEditor.this.fireValueChanged("field_editor_value", (Object)oldValue, (Object)NestedRadioGroupFieldEditor.this.value);
        }
    }
}

