/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.common.persistence.History;
import com.jrockit.mc.components.ui.behaviors.IShowable;
import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.design.GUIFactory;
import com.jrockit.mc.components.ui.design.LayoutToolkit;
import com.jrockit.mc.components.ui.design.Operation;
import com.jrockit.mc.components.ui.design.designelement.GUIDesigner;
import com.jrockit.mc.components.ui.design.designelement.IDesignElement;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.services.IServiceLocatorProvider;
import com.jrockit.mc.components.ui.tab.TabItemDescriptor;
import com.jrockit.mc.components.ui.util.HelpToolkit;
import com.jrockit.mc.ui.formpage.internal.MCFormEditor;
import com.jrockit.mc.ui.layout.SimpleLayout;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.HelpSupport;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;

public final class DesignerTab
extends FormPage {
    private final TabItemDescriptor m_tab;
    private final GUIDesigner m_designer;
    private final IServiceLocator m_parentServiceLocator;
    private final int m_delayTime;
    private IServiceLocator m_serviceLocator;
    private Composite m_container;
    private GUIFactory m_componentFactory;
    private boolean m_designMode;

    public DesignerTab(FormEditor editor, TabItemDescriptor tab, int delayTime) {
        super(editor, tab.getIdentifier(), tab.getName());
        this.m_delayTime = delayTime;
        this.m_tab = tab;
        this.m_parentServiceLocator = ((IServiceLocatorProvider)this.getEditor()).getServiceLocator();
        this.m_designer = new GUIDesigner(this.m_tab.getLayoutItem());
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
    }

    public IServiceLocator getServiceLocator() {
        return this.m_serviceLocator;
    }

    public void dispose() {
        super.dispose();
        this.unregisterMessageManager();
    }

    private void unregisterMessageManager() {
        if (this.m_serviceLocator != null) {
            this.m_serviceLocator.unregisterService("messageManager");
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        if (this.m_delayTime <= 0) {
            this.createTabContents(managedForm);
        } else {
            this.scheduleCreateTabContents(managedForm, this.m_delayTime);
        }
    }

    protected void scheduleCreateTabContents(final IManagedForm managedForm, int delay) {
        DisplayToolkit.safeTimerExec((Display)managedForm.getForm().getBody().getDisplay(), (int)delay, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (!managedForm.getForm().getBody().isDisposed()) {
                    DesignerTab.this.createTabContents(managedForm);
                    DesignerTab.this.showTab();
                }
            }
        });
    }

    private void createTabContents(IManagedForm managedForm) {
        Action helpAction = HelpSupport.getHelpAction((String)HelpToolkit.getHelpContextId(this.m_tab.getGUID()));
        if (helpAction != null) {
            managedForm.getForm().getToolBarManager().add((IAction)helpAction);
        }
        managedForm.getToolkit().decorateFormHeading(managedForm.getForm().getForm());
        managedForm.getForm().getBody().setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.m_container = this.createContainer(false);
    }

    private void showTab() {
        Object tab;
        if (((MCFormEditor)this.getEditor()).getPageCount() != 0 && (tab = this.getEditor().getSelectedPage()) == this && tab instanceof DesignerTab) {
            this.showComponents((DesignerTab)((Object)tab));
        }
    }

    private void showComponents(DesignerTab tab) {
        IServiceLocator sl = tab.getServiceLocator();
        UIScope comp = sl.getService(UIScope.class);
        for (IShowable s : comp.getAllComponents(IShowable.class)) {
            s.show();
        }
    }

    public void setDesignMode(boolean designMode) {
        if (this.m_designMode != designMode) {
            if (designMode) {
                this.m_designer.loadLayout(this.m_tab.getLayoutItem());
            } else {
                this.m_designer.commit();
            }
            this.m_designMode = designMode;
            this.destroy();
            this.m_container = this.createContainer(true);
        }
    }

    public boolean isInDesignMode() {
        return this.m_designMode;
    }

    private Composite createContainer(boolean show) {
        this.m_serviceLocator = this.m_parentServiceLocator.createChildService();
        this.m_serviceLocator.registerService("workbenchPartSite", this.getSite());
        this.m_serviceLocator.registerService("messageManager", this.getManagedForm().getMessageManager());
        this.m_componentFactory = GUIFactory.createChildFactory(this.m_serviceLocator);
        Composite container = this.getManagedForm().getToolkit().createComposite(this.getManagedForm().getForm().getBody());
        container.setLayout((Layout)new SimpleLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.m_designMode) {
            this.createDesign(container);
        } else {
            this.createUI(container);
        }
        if (show) {
            this.show(this.m_serviceLocator);
        }
        Composite formBody = this.getManagedForm().getForm().getBody();
        formBody.layout(true, true);
        return container;
    }

    private void show(IServiceLocator sl) {
        if (sl != null) {
            UIScope comp = sl.getService(UIScope.class);
            for (IShowable s : comp.getAllComponents(IShowable.class)) {
                s.show();
            }
        }
    }

    private void createUI(Composite container) {
        Control c = this.m_componentFactory.buildUI(container, this.m_tab.getLayoutItem());
        c.setLayoutData(LayoutToolkit.createSimpleLayoutData(this.m_tab.getLayoutItem()));
    }

    private void createDesign(Composite container) {
        this.m_designer.rebuild(container, this.m_serviceLocator, this.getSite().getSelectionProvider());
    }

    private void destroy() {
        if (this.m_container != null && !this.m_container.isDisposed()) {
            this.m_container.dispose();
        }
        this.m_container = null;
        if (this.m_serviceLocator != null) {
            UIScope ui = this.m_serviceLocator.getService(UIScope.class);
            if (ui.getParentScope() != null) {
                ui.getParentScope().removeChildScope(ui);
            }
            this.m_serviceLocator.dispose();
            this.m_serviceLocator = null;
        }
    }

    public Object getAdapter(Class adapter) {
        IManagedForm form;
        if (this.m_serviceLocator != null) {
            if (UIScope.class.equals((Object)adapter)) {
                return this.m_serviceLocator.getService(UIScope.class);
            }
            if (IServiceLocator.class.equals((Object)adapter)) {
                return this.m_serviceLocator;
            }
            Object object = this.findFirstAdaptableComponent(adapter);
            if (object != null) {
                return object;
            }
        }
        if (IMessageManager.class.isAssignableFrom(adapter) && (form = this.getManagedForm()) != null) {
            return form.getMessageManager();
        }
        return super.getAdapter(adapter);
    }

    private Object findFirstAdaptableComponent(Class<?> adapter) {
        UIScope comps = this.m_serviceLocator.getService(UIScope.class);
        if (comps != null) {
            for (IAdaptable adaptable : comps.getComponentsInAncestorScopes(IAdaptable.class)) {
                Object object = adaptable.getAdapter(adapter);
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }

    public IDesignElement getDesignElement() {
        return this.m_designer.getRootElement();
    }

    public History<Operation> getHistory() {
        return this.m_designer.getHistory();
    }

    public IDesignElement getSelectedElemented() {
        return this.m_designer.getSelectedObject();
    }
}

