/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

abstract class FileAction
extends Action {
    protected static final String FILE_EXTENSION_FILTERS = "*.xml";
    private final Shell m_shell;
    private final int m_style;
    private final String m_title;

    protected FileAction(Shell shell, int style, String title) {
        super(title);
        this.m_shell = shell;
        this.m_style = style;
        this.m_title = title;
    }

    protected abstract void fileOperation(Shell var1, String var2);

    protected abstract String createSuggestedFileName();

    protected final void showFileDialog() {
        FileDialog fileDialog = new FileDialog(this.m_shell, this.m_style);
        fileDialog.setFileName(this.createSuggestedFileName());
        fileDialog.setText(this.m_title);
        fileDialog.setFilterExtensions(new String[]{FILE_EXTENSION_FILTERS});
        String fileName = fileDialog.open();
        if (fileName != null) {
            this.fileOperation(this.m_shell, fileName);
        }
    }

    public final void run() {
        this.showFileDialog();
    }

    protected final void showError(String title, String message) {
        MessageBox messageBox = new MessageBox(this.m_shell, 33);
        messageBox.setText(title);
        messageBox.setMessage(message);
        messageBox.open();
    }
}

