/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.WeakHashMap;
import javax.swing.Timer;
import org.openide.explorer.ExplorerActions;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.SafeException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class ExplorerPanel
extends TopComponent
implements ExplorerManager.Provider {
    static final long serialVersionUID = 5522528786650751459L;
    private static MessageFormat formatExplorerTitle;
    private static final int INIT_DELAY = 70;
    private static final int MAX_DELAY = 350;
    private static Boolean scheduleAcivatedNodes;
    private static WeakHashMap panels;
    private ExplorerManager manager;
    private final transient PropertyChangeListener managerListener = new PropL();
    private ExplorerActions actions;
    private transient DelayedSetter delayedSetter;

    public ExplorerPanel(ExplorerManager explorerManager) {
        this(explorerManager, null);
    }

    public ExplorerPanel() {
        this(null, null);
    }

    ExplorerPanel(ExplorerManager explorerManager, boolean bl) {
        this(explorerManager, (Boolean)bl);
    }

    private ExplorerPanel(ExplorerManager explorerManager, Boolean bl) {
        if (explorerManager == null) {
            explorerManager = new ExplorerManager();
        }
        this.manager = explorerManager;
        panels.put(explorerManager, new WeakReference<ExplorerPanel>(this));
        this.setLayout(new BorderLayout());
        this.initActionMap(bl);
        this.initListening();
    }

    private void initActionMap(Boolean bl) {
        ExplorerActions explorerActions = new ExplorerActions(false);
        if (bl != null) {
            explorerActions.setConfirmDelete(bl);
        }
        explorerActions.attach(this.getExplorerManager());
    }

    static void associateActions(ExplorerActions explorerActions, ExplorerManager explorerManager) {
        ExplorerPanel explorerPanel;
        Reference reference = (Reference)panels.get(explorerManager);
        ExplorerPanel explorerPanel2 = explorerPanel = reference == null ? null : (ExplorerPanel)((Object)reference.get());
        if (explorerPanel != null) {
            explorerPanel.getActionMap().put("copy-to-clipboard", explorerActions.copyAction());
            explorerPanel.getActionMap().put("cut-to-clipboard", explorerActions.cutAction());
            explorerPanel.getActionMap().put("paste-from-clipboard", explorerActions.pasteAction());
            explorerPanel.getActionMap().put("delete", explorerActions.deleteAction());
            explorerPanel.actions = explorerActions;
        }
    }

    private void initListening() {
        ExplorerManager explorerManager = this.getExplorerManager();
        explorerManager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.managerListener, (Object)explorerManager));
        this.setActivatedNodes(this.manager.getSelectedNodes());
    }

    public void open() {
        this.open(WindowManager.getDefault().getCurrentWorkspace());
    }

    public void open(Workspace workspace) {
        super.open(workspace);
        this.setActivatedNodes(this.getExplorerManager().getSelectedNodes());
        this.updateTitle();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    protected void componentActivated() {
        if (this.actions != null) {
            this.actions.attach(this.getExplorerManager());
        }
    }

    protected void componentDeactivated() {
        if (this.actions != null) {
            this.actions.detach();
        }
    }

    protected void updateTitle() {
        String string;
        Node node;
        String string2 = "";
        ExplorerManager explorerManager = this.getExplorerManager();
        if (explorerManager != null && (node = explorerManager.getExploredContext()) != null && (string = node.getDisplayName()) != null) {
            string2 = string;
        }
        if (formatExplorerTitle == null) {
            formatExplorerTitle = new MessageFormat(NbBundle.getMessage(ExplorerPanel.class, (String)"explorerTitle"));
        }
        this.setName(formatExplorerTitle.format(new Object[]{string2}));
    }

    public HelpCtx getHelpCtx() {
        return ExplorerPanel.getHelpCtx(this.getExplorerManager().getSelectedNodes(), new HelpCtx(ExplorerPanel.class));
    }

    public static HelpCtx getHelpCtx(Node[] nodeArray, HelpCtx helpCtx) {
        return ExplorerUtils.getHelpCtx((Node[])nodeArray, (HelpCtx)helpCtx);
    }

    public static void setConfirmDelete(boolean bl) {
        NbPreferences.root().node("/org/netbeans/core").putBoolean("confirmDelete", bl);
    }

    public static boolean isConfirmDelete() {
        return NbPreferences.root().node("/org/netbeans/core").getBoolean("confirmDelete", true);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(new NbMarshalledObject((Object)this.manager));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof ExplorerManager) {
            this.manager = (ExplorerManager)object;
            panels.put(this.manager, new WeakReference<ExplorerPanel>(this));
            this.initActionMap(null);
            this.initListening();
            return;
        }
        NbMarshalledObject nbMarshalledObject = (NbMarshalledObject)object;
        try {
            this.manager = (ExplorerManager)nbMarshalledObject.get();
            panels.put(this.manager, new WeakReference<ExplorerPanel>(this));
            this.initActionMap(null);
            this.initListening();
        }
        catch (SafeException safeException) {
            throw safeException;
        }
        catch (IOException iOException) {
            throw new SafeException((Exception)iOException);
        }
    }

    private boolean delayActivatedNodes() {
        if (scheduleAcivatedNodes == null) {
            scheduleAcivatedNodes = System.getProperty("netbeans.delay.tc") != null ? (Boolean.getBoolean("netbeans.delay.tc") ? Boolean.TRUE : Boolean.FALSE) : Boolean.FALSE;
        }
        return scheduleAcivatedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleActivatedNodes(Node[] nodeArray) {
        ExplorerPanel explorerPanel = this;
        synchronized (explorerPanel) {
            if (this.delayedSetter == null) {
                this.delayedSetter = new DelayedSetter();
            }
        }
        this.delayedSetter.scheduleActivatedNodes(nodeArray);
    }

    static {
        panels = new WeakHashMap();
    }

    private class DelayedSetter
    implements ActionListener {
        private Node[] nodes;
        private Timer timer;
        private boolean firstChange = true;

        DelayedSetter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleActivatedNodes(Node[] nodeArray) {
            DelayedSetter delayedSetter = this;
            synchronized (delayedSetter) {
                this.nodes = nodeArray;
                if (this.timer == null) {
                    this.timer = new Timer(70, this);
                    this.timer.setCoalesce(true);
                    this.timer.setRepeats(false);
                }
                if (this.timer.isRunning()) {
                    if (this.timer.getInitialDelay() < 350) {
                        this.timer.setInitialDelay(this.timer.getInitialDelay() * 2);
                    }
                    this.firstChange = false;
                } else {
                    ExplorerPanel.this.setActivatedNodes(nodeArray);
                    this.firstChange = true;
                }
                this.timer.restart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DelayedSetter delayedSetter = this;
            synchronized (delayedSetter) {
                DelayedSetter delayedSetter2 = this;
                synchronized (delayedSetter2) {
                    this.timer.stop();
                }
            }
            if (!this.firstChange) {
                ExplorerPanel.this.setActivatedNodes(this.nodes);
            }
        }
    }

    private final class PropL
    implements PropertyChangeListener {
        PropL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() != ExplorerPanel.this.manager) {
                return;
            }
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                if (ExplorerPanel.this.delayActivatedNodes()) {
                    ExplorerPanel.this.scheduleActivatedNodes(ExplorerPanel.this.manager.getSelectedNodes());
                } else {
                    ExplorerPanel.this.setActivatedNodes(ExplorerPanel.this.manager.getSelectedNodes());
                }
                return;
            }
            if ("exploredContext".equals(propertyChangeEvent.getPropertyName())) {
                ExplorerPanel.this.updateTitle();
                return;
            }
        }
    }
}

