/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.model;

import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.PrivateStorageDelegate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RecordingTemplateRepository
extends Observable {
    private static Pattern NAME_WITH_COUNT_PATTERN = Pattern.compile("^(.*)\\s*\\((\\d+)\\)\\s*$");
    private static Pattern COUNT_SUFFIX_PATTERN = Pattern.compile("^\\s*\\((\\d+)\\)\\s*$");
    private static Comparator<IRecordingConfiguration> COMPARATOR = new Comparator<IRecordingConfiguration>(){

        @Override
        public int compare(IRecordingConfiguration first, IRecordingConfiguration second) {
            return first.getName().compareTo(second.getName());
        }
    };
    private final List<IRecordingConfiguration> m_templates = new ArrayList<IRecordingConfiguration>();
    private IRecordingConfiguration prototype = null;

    public void remove(IRecordingConfiguration t) {
        if (this.m_templates.remove(t)) {
            this.setChanged();
        }
    }

    public void add(IRecordingConfiguration t) {
        if (!this.m_templates.contains(t)) {
            this.m_templates.add(t);
            this.setChanged();
        }
    }

    public boolean contains(IRecordingConfiguration t) {
        return this.m_templates.contains(t);
    }

    public boolean replaceOriginalContentsFor(IRecordingConfiguration workingCopy) {
        RecordingTemplate original = (RecordingTemplate)workingCopy.getOriginal();
        if (original != null && original.replaceWithContentsFrom(workingCopy)) {
            original.save();
            this.setChanged();
            return true;
        }
        return false;
    }

    @Override
    public void notifyObservers(Object arg) {
        Collections.sort(this.m_templates, COMPARATOR);
        super.notifyObservers(arg);
    }

    public boolean isAllowedName(String name) {
        name = name.trim();
        for (IRecordingConfiguration rt : this.m_templates) {
            if (!name.equals(rt.getName().trim())) continue;
            return false;
        }
        return true;
    }

    public boolean addAsUnique(IRecordingConfiguration template) {
        String newName = this.nextUniqueName(template.getName());
        template.setName(newName);
        if (template.save()) {
            this.add(template);
            return true;
        }
        return false;
    }

    public String nextUniqueName(String originalName) {
        String baseName = originalName = originalName.trim();
        long proposedCount = -1L;
        Matcher matcher = NAME_WITH_COUNT_PATTERN.matcher(originalName);
        if (matcher.matches()) {
            try {
                long count = Long.parseLong(matcher.group(2));
                baseName = matcher.group(1).trim();
                proposedCount = count;
            }
            catch (NumberFormatException count) {
                // empty catch block
            }
        }
        int baseLen = baseName.length();
        for (IRecordingConfiguration template : this.m_templates) {
            String tempName = template.getName().trim();
            if (!tempName.startsWith(baseName)) continue;
            if (tempName.equals(baseName) && proposedCount < 1L) {
                proposedCount = 1L;
                continue;
            }
            Matcher tempMatch = COUNT_SUFFIX_PATTERN.matcher(tempName.substring(baseLen));
            if (!tempMatch.matches()) continue;
            try {
                long count = Long.parseLong(tempMatch.group(1));
                if (count >= Long.MAX_VALUE) continue;
                proposedCount = Math.max(proposedCount, count + 1L);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (proposedCount == -1L) {
            return baseName;
        }
        return String.valueOf(baseName) + " (" + proposedCount + ')';
    }

    public void setPrototypeTemplate(IRecordingConfiguration prototype) {
        if (prototype != this.prototype) {
            this.prototype = prototype;
            this.setChanged();
        }
    }

    public boolean canCreateTemplates() {
        return this.prototype != null;
    }

    public IRecordingConfiguration createTemplate() throws IOException {
        return this.prototype != null ? this.prototype.createCloneWithStorage(PrivateStorageDelegate.getDelegate()) : null;
    }

    public boolean isEmpty() {
        return this.m_templates.isEmpty();
    }

    public List<IRecordingConfiguration> getAllTemplates() {
        return Collections.unmodifiableList(this.m_templates);
    }
}

