/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.netbeans.core.options.keymap.api.KeyStrokeUtils;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class ShortcutListener
implements KeyListener {
    private JTextField textField;
    private boolean enterConfirms;
    private KeyStroke backspaceKS = KeyStroke.getKeyStroke(8, 0);
    private KeyStroke enterKS = KeyStroke.getKeyStroke(10, 0);
    private String key = "";
    private static final Method keyEvent_getExtendedKeyCode;

    public ShortcutListener(boolean bl) {
        this.enterConfirms = bl;
    }

    public void clear() {
        this.key = "";
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    static KeyStroke createKeyStroke(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent_getExtendedKeyCode != null) {
            try {
                int n2 = (Integer)keyEvent_getExtendedKeyCode.invoke((Object)keyEvent, new Object[0]);
                if (n2 != 0) {
                    n = n2;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                Exceptions.printStackTrace((Throwable)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
        }
        return KeyStroke.getKeyStroke(n, keyEvent.getModifiers());
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        boolean bl;
        assert (keyEvent.getSource() instanceof JTextField);
        if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 27) {
            return;
        }
        this.textField = (JTextField)keyEvent.getSource();
        KeyStroke keyStroke = ShortcutListener.createKeyStroke(keyEvent);
        boolean bl2 = bl = keyEvent.getKeyCode() != 16 && keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 18 && keyEvent.getKeyCode() != 157 && keyEvent.getKeyCode() != 65406;
        if (!this.enterConfirms || !keyStroke.equals(this.enterKS)) {
            if (keyStroke.equals(this.backspaceKS) && !this.key.equals("")) {
                int n = this.key.lastIndexOf(32);
                this.key = n < 0 ? "" : this.key.substring(0, n);
                this.textField.setText(this.key);
            } else {
                this.addKeyStroke(keyStroke, bl);
            }
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    private void addKeyStroke(KeyStroke keyStroke, boolean bl) {
        String string = Utilities.keyToString((KeyStroke)keyStroke, (boolean)true);
        KeyStroke keyStroke2 = Utilities.stringToKey((String)string);
        if (!keyStroke.equals(keyStroke2)) {
            return;
        }
        String string2 = KeyStrokeUtils.getKeyStrokeAsText(keyStroke);
        if (this.key.equals("")) {
            this.textField.setText(string2);
            if (bl) {
                this.key = string2;
            }
        } else {
            this.textField.setText(this.key + " " + string2);
            if (bl) {
                this.key = this.key + " " + string2;
            }
        }
    }

    static {
        Class<KeyEvent> clazz = KeyEvent.class;
        Method method = null;
        try {
            method = clazz.getMethod("getExtendedKeyCode", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            Exceptions.printStackTrace((Throwable)securityException);
        }
        keyEvent_getExtendedKeyCode = method;
    }
}

