/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.netbeans.core.startup.logging.NbFormatter;

final class MessagesHandler
extends StreamHandler {
    private final File dir;
    private final File[] files;
    private final long limit;

    MessagesHandler(File file) {
        this(file, -1, 0x100000L);
    }

    MessagesHandler(File file, int n, long l) {
        this.dir = file;
        if (n == -1 && (n = Integer.getInteger("org.netbeans.log.numberOfFiles", 3).intValue()) < 3) {
            n = 3;
        }
        File[] fileArray = new File[n];
        fileArray[0] = new File(file, "messages.log");
        for (int i = 1; i < fileArray.length; ++i) {
            fileArray[i] = new File(file, "messages.log." + i);
        }
        this.files = fileArray;
        this.limit = l;
        this.setFormatter(NbFormatter.FORMATTER);
        this.setLevel(Level.ALL);
        this.checkRotate(true);
        this.initStream();
    }

    private boolean checkRotate(boolean bl) {
        if (!bl && this.files[0].length() < this.limit) {
            return false;
        }
        this.flush();
        this.doRotate();
        return true;
    }

    private void initStream() {
        try {
            this.setOutputStream(new FileOutputStream(this.files[0], false));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.setOutputStream(System.err);
        }
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        super.publish(logRecord);
        if (this.checkRotate(false)) {
            this.initStream();
        }
    }

    private synchronized void doRotate() {
        this.close();
        int n = this.files.length;
        if (this.files[n - 1].exists()) {
            this.files[n - 1].delete();
        }
        for (int i = n - 2; i >= 0; --i) {
            if (!this.files[i].exists()) continue;
            this.files[i].renameTo(this.files[i + 1]);
        }
    }
}

